/*
 * Decompiled with CFR 0.152.
 */
package jace.core;

import jace.config.Reconfigurable;
import jace.core.Computer;
import jace.core.PagedMemory;
import jace.core.RAMEvent;
import jace.core.RAMListener;

public abstract class Card
implements Reconfigurable {
    private PagedMemory cxRom = new PagedMemory(256, PagedMemory.Type.cardFirmware);
    private PagedMemory c8Rom = new PagedMemory(2048, PagedMemory.Type.cardFirmware);
    private int slot;
    private RAMListener ioListener;
    private RAMListener firmwareListener;

    public abstract void reset();

    public abstract void disconnect();

    public void registerListeners() {
        this.ioListener = new RAMListener(RAMEvent.TYPE.ANY, RAMEvent.SCOPE.RANGE, RAMEvent.VALUE.ANY){

            @Override
            protected void doConfig() {
                this.setScopeStart(Card.this.slot * 16 + 49280);
                this.setScopeEnd(Card.this.slot * 16 + 49295);
            }

            @Override
            protected void doEvent(RAMEvent e) {
                int address = e.getAddress() - 49280 - Card.this.slot * 16;
                Card.this.handleIOAccess(address, e.getType(), e.getNewValue(), e);
            }
        };
        this.firmwareListener = new RAMListener(RAMEvent.TYPE.ANY, RAMEvent.SCOPE.RANGE, RAMEvent.VALUE.ANY){

            @Override
            protected void doConfig() {
                this.setScopeStart(Card.this.slot * 256 + 49152);
                this.setScopeEnd(Card.this.slot * 256 + 49152 + 255);
            }

            @Override
            protected void doEvent(RAMEvent e) {
                Computer.getComputer().getMemory().setActiveCard(Card.this.slot);
            }
        };
        Computer.getComputer().getMemory().addListener(this.ioListener);
        Computer.getComputer().getMemory().addListener(this.firmwareListener);
    }

    public void removeListeners() {
        Computer.getComputer().getMemory().removeListener(this.ioListener);
        Computer.getComputer().getMemory().removeListener(this.firmwareListener);
    }

    protected abstract void registerCustomListeners();

    protected abstract void handleIOAccess(int var1, RAMEvent.TYPE var2, int var3, RAMEvent var4);

    public int getSlot() {
        return this.slot;
    }

    public void setSlot(int slot) {
        this.slot = slot;
    }

    public PagedMemory getCxRom() {
        return this.cxRom;
    }

    public PagedMemory getC8Rom() {
        return this.c8Rom;
    }

    public abstract void motherboardTick();

    public void notifyVBLStateChanged(boolean state) {
    }
}

